# pokerdemo.tcl version 1.2
# coded by arfer <arfer.minute@gmail.com>
# on dalnet #windrop #eggdrops #tcl #eggdrop.conf #tclscript

# this script demonstrates use of the card parsing engine parsecards.tcl
# parsecards.tcl finds/recognises the best 5 card poker hand from an input string ...
# ... representation of 5 to 9 non duplicated playing cards
# logic is included in parsecards.tcl to also return the plain english poker name ...
# ... for the hand plus an enumerated ranking in order to make it easy to distinguish ...
# ... between two or more similar hands, thus making it suitable for inclusion in a ...
# ... multiuser game evironment
# for a detailed description of enumerated hand ranking see parsecards.txt

# ***** ENSURE parsecards.tcl is loaded BEFORE this script *****

# ensure channel is not +c because the script returns colorized text
# make changes if you wish to the configuration section (though not necessary)
# do make an effort to properly read the usage section
# see http://www.pagat.com/vying/pokerrank.html for an explanation of poker hand rankings

# ++++++++++ CHANGELOG ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ #

# version 1.0 tested july 2005 with windrop 1.6.17 handlen32 on dalnet using ...
# ... mIRC v6.16 client

# version 1.1 corrected error reported by HashPipe regarding misspelt namespace

# version 1.2 got rid of the unnecessary namespace import statement

# ++++++++++ WARRANTY +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ #

# this code comes with absolutely no warranty

# this program is free software; you can redistribute it and/or modify it under the ...
# ... terms of the gnu (general public license) as published by the free software ...
# ... foundation; either version 2 of the license, or (at your option) any later version

# this program is distributed in the hope that it will be useful, but without any ...
# ... warranty; without even the implied warranty of merchantability or fitness for a ...
# ... particular purpose

# see the gnu for more details (http://www.gnu.org/copyleft/gpl.html)

# ++++++++++ USAGE ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ #

# there are two ways to use this script

# 1. automatic
# type '.demo x' --> where x is a number between 5 and 9 inclusive
# bot will deal x random cards then find best 5 card hand, it's plain english poker ...
# ... name and it's enumerated hand ranking (if switched on in configuration section)
# example
# (nick) .demo 6
# (botnick): 6 Random Cards: Kd 2h Ts Qh Td Js
# (botnick): Best Poker Hand: Td Ts Kd Qh Js (Pair Of Tens)
# (botnick): Enumerated Ranking: 9 5 5 2 3 4

# 2. manual
# type '.demo c1 c2 c3 c4 c5 ... c9' --> where each argument is a 2 character ...
# ... textual representation of a card with first character A K Q J T (MUST be upper ...
# ... case), or 2-9 representing the card value, and the second character h c d or s ...
# ... (MUST be lower case) representing the suit (hearts, clubs, diamonds or spades ...
# ... respectively)
# the cards can be input in any order but there must not be less than 5 of them or ...
# ... more than 9 of them
# bot will find best 5 card hand, it's plain english poker name and it's enumerated ...
# ... hand ranking (if switched on in configuration section below)

# example
# (nick): .demo 4s 7c Th 3d 6d 5c 9s Ah
# (botnick): Best Poker Hand: 7c 6d 5c 4s 3d (Straight, Seven High)
# (botnick): Enumerated Ranking: 6 8 9 10 11 12

# error occurs ie. (botnick):Huh? --> for the following reasons :-
# 1. wrong number of arguments ... can be 1, or 5 - 9 (not 0 - 4, or more than 9)
# 2. there was 1 argument but it could not be interpreted as a number in the range 5 - 9
# 3. there was more than 1 argument but the bot can't understand the syntax/format of 1 or more of them
# 4. duplicate cards were input
# 5. K, Q, J, T were used to denote card values but were not all capitalised
# 6. h, c, d, s were used to denote card suits but were not all in upper case

# ++++++++++ BASIC CONFIGURATION ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ #

# edit these settings where appropriate

# the trigger character you want to precede the public commands with
set pkdemo_vTrigger "."

# set this to zero (0) if you do not wish to see the enumerated hand ranking
# see parsecards.txt for an explanation of enumerated hand ranking
set pkdemo_vShowRanks 1

# ++++++++++ CODE +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ #

# do not edit below this line

set pkdemo_vVersion "1.2"

proc pkdemo_pTrigger { } {
  global pkdemo_vTrigger
  return $pkdemo_vTrigger
}

bind PUB -|- [pkdemo_pTrigger]demo pkdemo_pPokerDemo

proc pkdemo_pPokerDemo {nick uhost hand chan arg} {
  global pkdemo_vShowRanks
  set vK 0
    if {[llength [split [string trim $arg]]] == 1} {
      if {[regexp {^[5-9]$} [string trim $arg]]} {
        set vK 1
        set vL [pkdemo_pRandomCards [string trim $arg]]
        putserv "PRIVMSG $chan :$arg Random Cards: [pkdemo_pColorizeCards $vL]"
      }
    } else {
      if {[llength [split [string trim $arg]]] >=5 && [llength [split [string trim $arg]]] <= 9} {
        for {set vX 0} {$vX < [llength [split [string trim $arg]]]} {incr vX} {
          set vM [lindex [split [string trim $arg]] $vX]
          if {![regexp {^[AKQJT98765432][hcds]$} [join $vM]] || [llength [lsearch -all -inline [split [string trim $arg]] $vM]] > 1} {
            set vK 0
            break
          }
          set vK 1
          set vL [string trim $arg]
        }
      }
    }
  if {$vK == 0} {
  putserv "PRIVMSG $chan :Huh\?"
  } else {
    set vN [split [nParseCards::pParseCards $vL] "\|"]
    set vO(1) [pkdemo_pColorizeCards [join [lindex $vN 0]]]
    set vO(2) "[join [lindex $vN 1]]"
    set vO(3) "[join [lindex $vN 2]]"
    putserv "PRIVMSG $chan :Best Poker Hand\: $vO(1) \($vO(2)\)"
    if {$pkdemo_vShowRanks != 0} {putserv "PRIVMSG $chan :Enumerated Ranking\: $vO(3)"}
  }
}

proc pkdemo_pRandomCards {vA} {
  set vK [pkdemo_pGenerateCards]
  set vL 0
  for {set vX 1} {$vX <= $vA} {incr vX} {
    set vM [rand [llength [split $vK]]]
    set vN [join [lindex [split $vK] $vM]]
    if {$vL == 0} {set vL $vN} else {set vL "$vL $vN"}
    set vK [join [lreplace [split $vK] $vM $vM]]
  }
  return $vL
}

proc pkdemo_pGenerateCards {} {
  set vK "AKQJT98765432"
  set vL "hcds"
  set vM 0
  for {set vX 0} {$vX < 4} {incr vX} {
    for {set vY 0} {$vY < 13} {incr vY} {
      set vN "[string index $vK $vY][string index $vL $vX]"
      if {$vM == 0} {set vM $vN} else {set vM "$vM $vN"}
    }
  }
  return $vM
}

proc pkdemo_pColorizeCards {vA} {
  set vK 0
  for {set vX 0} {$vX < [llength [split $vA]]} {incr vX} {
    set vL [join [lindex [split $vA] $vX]]
    if {[string index $vL 1] == "h" || [string index $vL 1] == "d"} {set vL "\00304$vL\003"} else {set vL "\00314$vL\003"}
    if {$vK == 0} {set vK $vL} else {set vK "$vK $vL"}
  }
  return $vK
}

putlog "pokerdemo.tcl version $pkdemo_vVersion by arfer loaded"
